<?
include_once '../sys/inc/start.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/loads.php'; // все необходимые функции для работы загруз-центра
include_once '../sys/inc/user.php';

define('DCMS_LF', realpath(H.'sys/loads/files/')); // путь до папки с загрузками

define('DCMS_LS', realpath(H.'sys/loads/screens/')); // путь до папки со скриншотами

if (isset($_GET['w']))
define('DCMS_SCR_WIDTH', max(64,min(1024,intval($_GET['w'])))); // максимальная ширина скриншотов
else
define('DCMS_SCR_WIDTH', IS_WEB?$set['loads_screen_size_web']:$set['loads_screen_size_wap']); // максимальная ширина скриншотов
//define('DCMS_SCR_WIDTH', 120); // максимальная ширина скриншотов

if (isset($_GET['f']))
{
$tmp_path=realpath(DCMS_LF.'/'.convert_of_utf8(urldecode($_GET['f'])));
if (preg_match('#^'.preg_quote(DCMS_LF).'#', $tmp_path))
{
$tmpfile=basename(convert_of_utf8(urldecode($_GET['f'])));
if (preg_match('#\.(gif|png|jpe?g)$#i',$tmpfile) && file_exists($tmp_path))
{
define('DCMS_LF_FILE', $tmpfile); // название файла на сервере
define('DCMS_LF_PATH', $tmp_path); // полный путь до файла
define('DCMS_LF_RAS', strtolower(preg_replace('#^.*\.#', NULL, DCMS_LF_FILE))); // расширение (в нижнем регистре)

define('DCMS_LF_NAME', basename(DCMS_LF_FILE,'.'.preg_replace('#^.*\.#', NULL, DCMS_LF_FILE))); // имя файла без расширения

define('DCMS_LF_SIZE', filesize(DCMS_LF_PATH)); // размер файла в байтах
define('DCMS_LF_TIME', filectime(DCMS_LF_PATH)); // время создания файла
define('DCMS_LF_UFILE', convert_to_utf8(DCMS_LF_FILE)); // для записи в базу

}
}
}

if (!defined('DCMS_LF_FILE'))exit;
define('SCR_FILE',DCMS_LS.'/'.'width-'.DCMS_SCR_WIDTH.'_'.DCMS_LF_NAME.DCMS_LF_SIZE.'.'.DCMS_LF_RAS);

header("Last-Modified: ".gmdate("D, d M Y H:i:s", DCMS_LF_TIME)." GMT");
header("Expires: ".gmdate("D, d M Y H:i:s", $time + 3600)." GMT");
header('Content-type: image/'.DCMS_LF_RAS);
header('Content-Disposition: filename='.DCMS_LF_UFILE.'.'.DCMS_LF_RAS);

// чтобы не ресайзить каждый раз
if (file_exists(SCR_FILE) && filesize(SCR_FILE))
{
header('Content-length: '.filesize(SCR_FILE));
echo file_get_contents(SCR_FILE);
exit;
}

switch (DCMS_LF_RAS) {
case 'jpg':$img=imagecreatefromjpeg(DCMS_LF_PATH);break;
case 'jpeg':$img=imagecreatefromjpeg(DCMS_LF_PATH);break;
case 'gif':$img=imagecreatefromgif(DCMS_LF_PATH); $img_string=file_get_contents(DCMS_LF_PATH); break;
case 'png':$img=imagecreatefrompng(DCMS_LF_PATH);break;
}

$img_x=imagesx($img);
$img_y=imagesy($img);

$x_ratio = DCMS_SCR_WIDTH/$img_x; 
if ($img_x <= DCMS_SCR_WIDTH)
{
$dstW = $img_x; 
$dstH = $img_y; 
}
else
{
$dstH = ceil($x_ratio * $img_y);
$dstW = DCMS_SCR_WIDTH;
}

if (DCMS_LF_RAS=='gif')
{
include_once H.'sys/inc/gifdecoder.php';
include_once H.'sys/inc/gifencoder.php';
$giff = new GIFDecoder ( $img_string );
$arr = $giff->GIFGetFrames ( ); // разрезание gif анимации на отдельные картинки
$dly = $giff->GIFGetDelays ( );
// сохраняем отдельные кадры
for ($i=0;$i<count($arr);$i++)
{
$frames[]=H."sys/tmp/frame_$sess.$i.gif";
file_put_contents(H."sys/tmp/frame_$sess.$i.gif", $arr[$i]);
@chmod(H."sys/tmp/frame_$sess.$i.gif",0777);
}
// масштабируем кадры
for ($i=0;$i<count($arr);$i++)
{
$imgc[$i]=imagecreatefromgif(H."sys/tmp/frame_$sess.$i.gif");
$frame_img[$i]=imagecreatetruecolor($dstW, $dstH);
imagecopyresampled($frame_img[$i], $imgc[$i], 0, 0, 0, 0, $dstW, $dstH, $img_x, $img_y);
imagedestroy($imgc[$i]);
$frame_img[$i]=img_copyright($frame_img[$i]);
imagegif($frame_img[$i],H."sys/tmp/frame_$sess.$i.gif");
imagedestroy($frame_img[$i]);
}
// собираем анимацию
$gif = @new GIFEncoder	($frames,$dly,0,2,0, 0, 0,"url");
// удаляем кадры
for ($i=0;$i<count($arr);$i++)unlink(H."sys/tmp/frame_$sess.$i.gif");

@file_put_contents(SCR_FILE, $gif->GetAnimation());

}
else
{
$screen=ImageCreateTrueColor($dstW, $dstH);
imagecopyresampled($screen, $img, 0, 0, 0, 0, $dstW, $dstH, $img_x, $img_y);
imagedestroy($img);
$screen=img_copyright($screen); // наложение копирайта
}


switch (DCMS_LF_RAS) {
case 'jpg':@ImageJpeg ($screen, SCR_FILE, 100);break;
case 'jpeg':@ImageJpeg ($screen, SCR_FILE, 100);break;
case 'gif':@ImageGif ($screen, SCR_FILE);break;
case 'png':@ImagePng ($screen, SCR_FILE);break;
}
chmod(SCR_FILE, 0777);
echo file_get_contents(SCR_FILE);
exit;


?>