<?php
function strip_tags_smart(
     $s,
    array $allowable_tags = null,
     $is_format_spaces = false,
    array $pair_tags = array('script', 'style', 'map', 'iframe', 'frameset', 'object', 'applet', 'comment', 'button'),
    array $para_tags = array('p', 'td', 'th', 'li', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'div', 'form', 'title')
)
{
    static $_callback_type  = false;
    static $_allowable_tags = array();
    static $_para_tags      = array();
    static $re_attrs_fast_safe =  '(?> (?>[\x20\r\n\t]+|\xc2\xa0)+  #пробельные символы (д.б. обязательно)
                                       (?>
                                         #правильные атрибуты
                                                                        [^>"\']+
                                         | (?<=[\=\x20\r\n\t]|\xc2\xa0) "[^"]*"
                                         | (?<=[\=\x20\r\n\t]|\xc2\xa0) \'[^\']*\'
                                         #разбитые атрибуты
                                         |                              [^>]+
                                       )*
                                   )?';
    if (is_array($s) && $_callback_type === 'strip_tags')
    {
        $tag = strtolower($s[1]);
        if ($_allowable_tags &&
            (array_key_exists($tag, $_allowable_tags) || array_key_exists('<' . trim(strtolower($s[0]), '< />') . '>', $_allowable_tags))
            ) return $s[0];
        if ($tag == 'br') return "\r\n";
        if ($_para_tags && array_key_exists($tag, $_para_tags)) return "\r\n\r\n";
        return '';
    }
    if (($pos = strpos($s, '<') === false) || strpos($s, '>', $pos) === false)  
    {
        return $s;
    }
    $re_tags = '/<[\/\!]? ([a-zA-Z][a-zA-Z\d]* (?>\:[a-zA-Z][a-zA-Z\d]*)?)' . $re_attrs_fast_safe . '\/?>/sx';
    $patterns = array(
        '/<([\?\%]) .*? \\1>/sx',     
        '/<\!\[CDATA\[ .*? \]\]>/sx', 
        '/<\!--.*?-->/s', 
        '/<\! (?>--)?
              \[
              (?> [^\]"\']+ | "[^"]*" | \'[^\']*\' )*
              \]
              (?>--)?
         >/sx',
    );
    if ($pair_tags)
    {
        foreach ($pair_tags as $k => $v) $pair_tags[$k] = preg_quote($v, '/');
        $patterns[] = '/<((?i:' . implode('|', $pair_tags) . '))' . $re_attrs_fast_safe . '> .*? <\/(?i:\\1)' . $re_attrs_fast_safe . '>/sx';
    }
    $i = 0; 
    $max = 99;
    while ($i < $max)
    {
        $s2 = preg_replace($patterns, '', $s);
        if ($i == 0)
        {
            $is_html = ($s2 != $s || preg_match($re_tags, $s2));
            if ($is_html)
            {
                $s2 = strtr($s2, "\x09\x0a\x0c\x0d", '    ');
                if ($allowable_tags) $_allowable_tags = array_flip($allowable_tags);
                if ($para_tags) $_para_tags = array_flip($para_tags);
            }
        }
        if ($is_html)
        {
            $_callback_type = 'strip_tags';
            $s2 = preg_replace_callback($re_tags, __FUNCTION__, $s2);
            $_callback_type = false;
        }
        if ($s === $s2) break;
        $s = $s2; $i++;
    }
    if ($i >= $max) $s = strip_tags($s); 
    if ($is_format_spaces || $is_html)
    {
        $s = preg_replace('/\x20\x20+/s', ' ', trim($s));
        $s = str_replace(array("\r\n\x20", "\x20\r\n"), "\r\n", $s);
        $s = preg_replace('/\r\n[\r\n]+/s', "\r\n\r\n", $s);
    }
    return $s;
}
?>
