<?php
function utf8_convert_case($s, $mode)
{
    static $trans = array(
        "\x41" => "\x61", 
        "\x42" => "\x62", 
        "\x43" => "\x63", 
        "\x44" => "\x64", 
        "\x45" => "\x65", 
        "\x46" => "\x66", 
        "\x47" => "\x67", 
        "\x48" => "\x68", 
        "\x49" => "\x69", 
        "\x4a" => "\x6a", 
        "\x4b" => "\x6b", 
        "\x4c" => "\x6c", 
        "\x4d" => "\x6d", 
        "\x4e" => "\x6e", 
        "\x4f" => "\x6f", 
        "\x50" => "\x70", 
        "\x51" => "\x71", 
        "\x52" => "\x72", 
        "\x53" => "\x73", 
        "\x54" => "\x74", 
        "\x55" => "\x75", 
        "\x57" => "\x77", 
        "\x56" => "\x76", 
        "\x58" => "\x78", 
        "\x59" => "\x79", 
        "\x5a" => "\x7a", 
        "\xd0\x81" => "\xd1\x91", 
        "\xd0\x90" => "\xd0\xb0", 
        "\xd0\x91" => "\xd0\xb1", 
        "\xd0\x92" => "\xd0\xb2", 
        "\xd0\x93" => "\xd0\xb3", 
        "\xd0\x94" => "\xd0\xb4", 
        "\xd0\x95" => "\xd0\xb5", 
        "\xd0\x96" => "\xd0\xb6", 
        "\xd0\x97" => "\xd0\xb7", 
        "\xd0\x98" => "\xd0\xb8", 
        "\xd0\x99" => "\xd0\xb9", 
        "\xd0\x9a" => "\xd0\xba", 
        "\xd0\x9b" => "\xd0\xbb", 
        "\xd0\x9c" => "\xd0\xbc", 
        "\xd0\x9d" => "\xd0\xbd", 
        "\xd0\x9e" => "\xd0\xbe", 
        "\xd0\x9f" => "\xd0\xbf", 
        "\xd0\xa0" => "\xd1\x80", 
        "\xd0\xa1" => "\xd1\x81", 
        "\xd0\xa2" => "\xd1\x82", 
        "\xd0\xa3" => "\xd1\x83", 
        "\xd0\xa4" => "\xd1\x84", 
        "\xd0\xa5" => "\xd1\x85", 
        "\xd0\xa6" => "\xd1\x86", 
        "\xd0\xa7" => "\xd1\x87", 
        "\xd0\xa8" => "\xd1\x88", 
        "\xd0\xa9" => "\xd1\x89", 
        "\xd0\xaa" => "\xd1\x8a", 
        "\xd0\xab" => "\xd1\x8b", 
        "\xd0\xac" => "\xd1\x8c", 
        "\xd0\xad" => "\xd1\x8d", 
        "\xd0\xae" => "\xd1\x8e", 
        "\xd0\xaf" => "\xd1\x8f", 
        "\xd2\x96" => "\xd2\x97", 
        "\xd2\xa2" => "\xd2\xa3", 
        "\xd2\xae" => "\xd2\xaf", 
        "\xd2\xba" => "\xd2\xbb", 
        "\xd3\x98" => "\xd3\x99", 
        "\xd3\xa8" => "\xd3\xa9", 
        "\xd2\x90" => "\xd2\x91",  
        "\xd0\x84" => "\xd1\x94",  
        "\xd0\x86" => "\xd1\x96",  
        "\xd0\x87" => "\xd1\x97",  
        "\xd0\x8e" => "\xd1\x9e",  
        "\xc3\x84" => "\xc3\xa4", 
        "\xc3\x87" => "\xc3\xa7", 
        "\xc3\x91" => "\xc3\xb1", 
        "\xc3\x96" => "\xc3\xb6", 
        "\xc3\x9c" => "\xc3\xbc", 
        "\xc4\x9e" => "\xc4\x9f", 
        "\xc4\xb0" => "\xc4\xb1", 
        "\xc5\x9e" => "\xc5\x9f", 
        "\xc4\x8c" => "\xc4\x8d",  
        "\xc4\x86" => "\xc4\x87",  
        "\xc4\x90" => "\xc4\x91",  
        "\xc5\xa0" => "\xc5\xa1",  
        "\xc5\xbd" => "\xc5\xbe",  
        "\xc3\x80" => "\xc3\xa0",  
        "\xc3\x82" => "\xc3\xa2",  
        "\xc3\x86" => "\xc3\xa6",  
        "\xc3\x88" => "\xc3\xa8",  
        "\xc3\x89" => "\xc3\xa9",  
        "\xc3\x8a" => "\xc3\xaa",  
        "\xc3\x8b" => "\xc3\xab",  
        "\xc3\x8e" => "\xc3\xae",  
        "\xc3\x8f" => "\xc3\xaf",  
        "\xc3\x94" => "\xc3\xb4",  
        "\xc5\x92" => "\xc5\x93",  
        "\xc3\x99" => "\xc3\xb9",  
        "\xc3\x9b" => "\xc3\xbb",  
        "\xc5\xb8" => "\xc3\xbf",  
    );
    if ($mode == CASE_UPPER)
    {
        if (function_exists('mb_strtoupper')) return mb_strtoupper($s, 'utf-8');
        if (preg_match('/^[\x00-\x7e]*$/', $s)) return strtoupper($s); 
        strtr($s, array_flip($trans));
    }
    elseif ($mode == CASE_LOWER)
    {
        if (function_exists('mb_strtolower')) return mb_strtolower($s, 'utf-8');
        if (preg_match('/^[\x00-\x7e]*$/', $s)) return strtolower($s); 
        strtr($s, $trans);
    }
    else
    {
        trigger_error('Parameter 2 should be a constant of CASE_LOWER or CASE_UPPER!', E_USER_WARNING);
        return $s;
    }
    return $s;
}
function utf8_lowercase($s)
{
    return utf8_convert_case($s, CASE_LOWER);
}
function utf8_uppercase($s)
{
    return utf8_convert_case($s, CASE_UPPER);
}
?>
